<?php

	class TStat
	{
		public $points;
		function __construct() 
		{
			$this->points['A'] = 0;
			$this->points['B'] = 0;
			$this->points['C'] = 0;
			$this->points['D'] = 0;
			$this->points['E'] = 0;
			$this->points['F'] = 0;
			$this->points['G'] = 0;
			$this->points['H'] = 0;
			$this->points['1/8'] = 0;
			$this->points['1/4'] = 0;
			$this->points['1/2'] = 0;
			$this->points['3rd'] = 0;
			$this->points['Finale'] = 0;
			$this->points['Fragen'] = 0;
		}	
	}
   
	function getMax($all, $key)
	{
		foreach ($all as $k => $v)
		{
			$a[] = $v->points[$key];
		}
		return max($a);
	}

	$sql = "SELECT members.Name, matches.level, SUM(tips.TipScore) as Score
			FROM tips 
			JOIN members ON tips.memberID = members.ID 
			JOIN matches ON tips.matchID = matches.ID 
			WHERE tips.TipScore >= 0 
			GROUP BY members.Name, matches.level
			UNION
			SELECT members.Name, 'Fragen', SUM(specialtips.SpecialTipScore) as Score
			FROM specialtips
			JOIN members ON specialtips.memberID = members.ID 
			WHERE specialtips.SpecialTipScore >= 0 
			GROUP BY members.Name";
		
		
	$result = mysql_query($sql);

	$players = Array();
	while ($row = mysql_fetch_assoc($result))
	{
		$player = $row['Name'];
		if (! isset($players[$player]))
		{
			$players[$player] = new TStat();
		}
		switch ($row['level'])
		{
			case 'Gruppe A':
				$players[$player]->points['A'] = $row['Score'];
				break;
			case 'Gruppe B':
				$players[$player]->points['B'] = $row['Score'];
				break;
			case 'Gruppe C':
				$players[$player]->points['C'] = $row['Score'];
				break;
			case 'Gruppe D':
				$players[$player]->points['D'] = $row['Score'];
				break;
			case 'Gruppe E':
				$players[$player]->points['E'] = $row['Score'];
				break;
			case 'Gruppe F':
				$players[$player]->points['F'] = $row['Score'];
				break;
			case 'Gruppe G':
				$players[$player]->points['G'] = $row['Score'];
				break;
			case 'Gruppe H':
				$players[$player]->points['H'] = $row['Score'];
				break;
			case 'Achtelfinale':
				$players[$player]->points['1/8'] = $row['Score'];
				break;
			case 'Viertelfinale':
				$players[$player]->points['1/4'] = $row['Score'];
				break;
			case 'Halbfinale':
				$players[$player]->points['1/2'] = $row['Score'];
				break;
			case 'Spiel um Platz 3':
				$players[$player]->points['3rd'] = $row['Score'];
				break;
			case 'Finale':
				$players[$player]->points['Finale'] = $row['Score'];
				break;
			case 'Fragen':
				$players[$player]->points['Fragen'] = $row['Score'];
				break;
		}		
	}

?>

<table id="tblPoints">
	<thead>
		<tr>
			<td rowspan=2>Name</td>
			<td colspan=8>Gruppenspiele</td>
			<td colspan=5>KO-Runde</td>
			<td rowspan=2>Fragen</td>
		</tr>
		<tr>
			<td>A</td>
			<td>B</td>
			<td>C</td>
			<td>D</td>
			<td>E</td>
			<td>F</td>
			<td>G</td>
			<td>H</td> 
			<td>1/8</td>
			<td>1/4</td>
			<td>1/2</td>
			<td>3rd</td>
			<td>Finale</td>
		</tr>
	</thead>
<tbody>
<?php
	$max = new TStat();
	$max->points['A'] = getMax($players, 'A');
	$max->points['B'] = getMax($players, 'B');
	$max->points['C'] = getMax($players, 'C');
	$max->points['D'] = getMax($players, 'D');
	$max->points['E'] = getMax($players, 'E');
	$max->points['F'] = getMax($players, 'F');
	$max->points['G'] = getMax($players, 'G');
	$max->points['H'] = getMax($players, 'H');
	$max->points['1/8'] = getMax($players, '1/8');
	$max->points['1/4'] = getMax($players, '1/4');
	$max->points['1/2'] = getMax($players, '1/2');
	$max->points['3rd'] = getMax($players, '3rd');
	$max->points['Finale'] = getMax($players, 'Finale');
	$max->points['Fragen'] = getMax($players, 'Fragen');

	function printCell($stat, $key, $max)
	{
		if ($stat->points[$key] != 0)
		{
			$class = $stat->points[$key] == $max->points[$key] ? "gold" : "";
			echo "<td class=\"$class\">".$stat->points[$key]."</td>";	
		}
		else
		{
			echo "<td>".$stat->points[$key]."</td>";	
		}
	}

	foreach ($players as $key => $value) 
	{
		if($key == $_COOKIE['MemberName'])
		{
			echo "<tr class=\"ownRow\">";
		}
		else
		{
			echo "<tr>";
		}
		echo "<td>".$key."</td>";
		
		printCell($value, 'A', $max);
		printCell($value, 'B', $max);
		printCell($value, 'C', $max);
		printCell($value, 'D', $max);
		printCell($value, 'E', $max);
		printCell($value, 'F', $max);
		printCell($value, 'G', $max);
		printCell($value, 'H', $max);
		printCell($value, '1/8', $max);
		printCell($value, '1/4', $max);
		printCell($value, '1/2', $max);
		printCell($value, '3rd', $max);
		printCell($value, 'Finale', $max);
		printCell($value, 'Fragen', $max);
		echo "</tr>";
	}
?>
</tbody>
</table>

<script type="text/javascript" src="../1/images/jquery-1.11.1.min.js"></script>
<script type="text/javascript" language="javascript" src="../../1/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="../../1/images/jquery.dataTables.min.css">
<script type="text/javascript">
	$(function()
	{
		$("#tblPoints").dataTable({
			"paging":false,
			"order": [ 0, 'asc' ],
			"columnDefs": [
				{ "orderSequence": [ "desc", "asc" ], "targets": [ 1,2,3,4,5,6,7,8,9,10,11 ] },
			]
		});
	});
</script>